/*
 * Created on Aug 1, 2003
 */
package Interface;
import Validators.*;
import Data.*;
import DatabaseCommunication.*;
import XmlCommunication.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;

/**
 * @author student
 * This class is being used for implement the Resgister of user.
 * 
 */
public class TabRegister extends JFrame implements ActionListener {

	//boolean inAnApplet = true;
	private static int unique = 0;
	
	private XmlGenerator xmlgenerator;
	private XmlUnmarshal xmlunmarshal;

	static JLabel uLabel = new JLabel("User Name");
	static JTextField uName = new JTextField(15);
	static JLabel fLabel = new JLabel("First Name");
	static JTextField fName = new JTextField(15);
	static JLabel lLabel = new JLabel("Last Name");
	static JTextField lName = new JTextField(15);
	static JLabel cLabel = new JLabel("Contact Number");
	static JTextField contactNumber = new JTextField(15);
	static JLabel mLabel = new JLabel("Mobile Number(optional)");
	static JTextField mobileNumber = new JTextField(15);
	static JLabel eLabel = new JLabel("Email Address");
	static JTextField emailAddress = new JTextField(15);
	static JLabel pLabel = new JLabel("Password");
	static JPasswordField password = new JPasswordField(15);
	static JLabel vLabel = new JLabel("Verify");
	static JPasswordField verifier = new JPasswordField(15);

	static JButton registerButton = new JButton("REGISTER");
	static JButton loginButton = new JButton("LOGIN");

	static UserData user = new UserData();

	static JLabel message = new JLabel();
	static JFrame login;

	/**
	 * This is the constructor for TabRegister.java
	 */
	public TabRegister(JFrame login) {
		super();
		TabRegister.login = login;

		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				displayMessage("Window closing", e);
				dispose();
				System.exit(0);

			}
			public void windowClosed(WindowEvent e) {
				displayMessage("Window closed", e);
			}
			public void windowOpened(WindowEvent e) {
				displayMessage("Window opened", e);
			}

			public void windowIconified(WindowEvent e) {
				displayMessage("Window iconified", e);
			}

			public void windowDeiconified(WindowEvent e) {
				displayMessage("Window deiconified", e);
			}

			public void windowActivated(WindowEvent e) {
				displayMessage("Window activated", e);

			}

			public void windowDeactivated(WindowEvent e) {
				displayMessage("Window deactivated", e);
			}
		});

		displayWindow();
		createPanel();

	}

	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		if (command == "register") {
			doRegister();
		}
		if (command == "back to login") {
			login.setVisible(true);
			this.setVisible(false);
		}
	}
	/**
	 * Implements the registeration process.
	 **/
	public void doRegister() {

		user.setLoginId(uName.getText());
		user.setFName(fName.getText());
		user.setLName(lName.getText());
		user.setContactNumber(contactNumber.getText());
		user.setMobileNumber(mobileNumber.getText());
		user.setEmailAddress(emailAddress.getText());
		user.setPassword(password.getText());
		user.setVerifier(verifier.getText());

		UserValidator uv = new UserValidator();
		NewLoginValidator nlv = new NewLoginValidator();
		if (!uv.validate(user)) {
			System.out.println("Register Failed :" + uv.getMessage());
			message.setText("Register Failed :" + uv.getMessage());
			return;

		} else if (!nlv.validate(user)) {
			System.out.println("Register Failed :" + uv.getMessage());
			message.setText("Register Failed :" + nlv.getMessage());
			return;
		} else {

			////form xml message..
			String xmlstr = XmlGenerator.adminAddXml(user);
			//				  
			////send and get xml message to/from TMS
			String res = ServletConnection.sendXml(xmlstr);
			//				  
			////interpret xml message from TMS
			String s = XmlUnmarshal.readResponse(res);
			//				
			int rgCode = Integer.parseInt(XmlUnmarshal.getResponseGeneralCode());
			if (rgCode == 9) {
				System.out.println(rgCode);
				message.setText(
					"Register Failed : Username is already in use.");
				System.out.println(
				XmlUnmarshal.getResponseGeneralDescription());
				return;
			} else if (rgCode > 0) {
				message.setText("Register Failed.");
				return;
			} else {
				populateLocalDatabase();
				message.setText(
					"Register Successful."
						+ '\n'
						+ "Your username is "
						+ user.getLoginId());
			}
			int id = XmlUnmarshal.getNcbId();
			if (id != -1) {
				s = "Your Ncb ID is: " + id + ". ";				
				user.setNcbId(id);
			}
		}
	}

	/**
	 * This method is being used to display window events
	 */
	void displayMessage(String prefix, WindowEvent e) {
//		System.out.println(prefix + ": " + e.getWindow() + "\n");
	}
	/**
	 * This method is being used to display registration window
	 *  void
	 */
	void displayWindow() {
		JFrame.setDefaultLookAndFeelDecorated(true);
		this.setSize(550, 350);
		centerDialog(this);
//		this.setResizable(false);
		this.setTitle("Pinboard Application");
		ImageIcon img = new ImageIcon("./Interface/pinboard.gif");
		this.setIconImage(img.getImage());

	}
	/**
	 * Create Registration Panel
	 */
	void createPanel() {
		Container contentPane = getContentPane();

		TitledBorder loginTitled = BorderFactory.createTitledBorder("Register");
		JPanel rPanel = new JPanel();
		rPanel.setBorder(loginTitled);
		rPanel.setLayout(new GridLayout(0, 2));

		rPanel.add(uLabel);
		uLabel.setLabelFor(uName);
		uName.setEditable(true);
		rPanel.add(uName);

		rPanel.add(fLabel);
		fLabel.setLabelFor(fName);
		fName.setEditable(true);
		rPanel.add(fName);

		rPanel.add(lLabel);
		lLabel.setLabelFor(lName);
		lName.setEditable(true);
		rPanel.add(lName);

		rPanel.add(cLabel);
		cLabel.setLabelFor(contactNumber);
		contactNumber.setEditable(true);
		rPanel.add(contactNumber);

		rPanel.add(mLabel);
		mLabel.setLabelFor(mobileNumber);
		mobileNumber.setEditable(true);
		rPanel.add(mobileNumber);

		rPanel.add(eLabel);
		eLabel.setLabelFor(emailAddress);
		emailAddress.setEditable(true);
		rPanel.add(emailAddress);

		rPanel.add(pLabel);
		eLabel.setLabelFor(password);
		password.setEditable(true);
		rPanel.add(password);

		rPanel.add(vLabel);
		eLabel.setLabelFor(verifier);
		verifier.setEditable(true);
		rPanel.add(verifier);

		rPanel.add(loginButton);
		rPanel.add(registerButton);

		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
		panel.add(rPanel);

		message.setHorizontalAlignment(SwingConstants.CENTER);
		message.setFont(new Font("Times New Roman", Font.ITALIC, 16));
		message.setForeground(Color.RED);
		panel.add(message);
		registerButton.setActionCommand("register");
		loginButton.addActionListener(this);
		loginButton.setActionCommand("back to login");
		registerButton.addActionListener(this);

		contentPane.add(panel, BorderLayout.CENTER);

		this.setVisible(true);
	}

	/**
	 * This method is being used to populate the application database
	 *  void
	 */
	private void populateLocalDatabase() {
		UserManager uManager = new UserManager();
		try {
			uManager.insertUserData(user);
			message.setText("user is now inserted");
		} catch (Exception exp) {
			message.setText(
				"Error while inserting user data " + exp.toString());
			return;
		}
	}
	/**
	 * This method is being used to centre the Registration window
	 */
	//	Center a dialog on screen
	public static void centerDialog(Window frame) {
		Dimension dialogSize = frame.getSize();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation(
			screenSize.width / 2 - dialogSize.width / 2,
			screenSize.height / 2 - dialogSize.height / 2);
	}

}
